/*
 * Decompiled with CFR 0.152.
 */
package exsid;

import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import com.ftdi.FlowControl;
import com.ftdi.Parity;
import com.ftdi.StopBits;
import com.ftdi.WordLength;
import exsid.AudioOp;
import exsid.ChipSelect;
import exsid.ClockSelect;
import exsid.HardwareModel;
import exsid.HardwareSpecs;
import exsid.IExSID;
import exsid.SupportedDevices;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ExSID
implements IExSID {
    private static final Logger logger = Logger.getLogger(ExSID.class.getName());
    private FTDevice device;
    private long clkdrift;
    private HardwareSpecs hardwareSpecs = new HardwareSpecs();
    private byte[] bufptr = null;
    private byte[] bufchar0 = new byte[7998];
    private byte[] bufchar1 = new byte[7998];
    private byte[] frontbuf = this.bufchar0;
    private byte[] backbuf = this.bufchar1;
    private int frontbufIdx;
    private int backbufIdx;
    private Object frontbufMtx = new Object();
    private Thread exSIDthreadOutput = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Object object = ExSID.this.frontbufMtx;
                    synchronized (object) {
                        while (ExSID.this.frontbufIdx == 0) {
                            ExSID.this.frontbufMtx.wait();
                        }
                        if (ExSID.this.frontbufIdx < 0) {
                            return;
                        }
                        ExSID.this.xSwrite(ExSID.this.frontbuf, ExSID.this.frontbufIdx);
                        ExSID.this.frontbufIdx = 0;
                        ExSID.this.frontbufMtx.notify();
                    }
                }
            }
            catch (FTD2XXException | InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    });

    @Override
    public String exSID_error_str() {
        return "";
    }

    private void xSwrite(byte[] buff, int size) throws FTD2XXException {
        this.device.write(buff, 0, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int xSread(byte[] buff, int size) throws FTD2XXException, InterruptedException {
        Object object = this.frontbufMtx;
        synchronized (object) {
            while (this.frontbufIdx != 0) {
                this.frontbufMtx.wait();
            }
            return this.device.read(buff, 0, size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xSoutb(byte b, int flush) throws FTD2XXException, InterruptedException {
        this.backbuf[this.backbufIdx++] = b;
        if (this.backbufIdx < 7998 && flush == 0) {
            return;
        }
        Object object = this.frontbufMtx;
        synchronized (object) {
            while (this.frontbufIdx != 0) {
                this.frontbufMtx.wait();
            }
            if (flush < 0) {
                this.frontbufIdx = -1;
            } else {
                this.bufptr = this.frontbuf;
                this.frontbuf = this.backbuf;
                this.frontbufIdx = this.backbufIdx;
                this.backbuf = this.bufptr;
                this.backbufIdx = 0;
            }
            this.frontbufMtx.notify();
        }
    }

    @Override
    public int exSID_init() {
        if (this.device != null && this.device.isOpen()) {
            System.err.println("Device is already open!");
            return -1;
        }
        try {
            this.device = null;
            List devices = FTDevice.getDevices((boolean)false).stream().sorted((d1, d2) -> d1.getDevSerialNumber().compareTo(d2.getDevSerialNumber())).collect(Collectors.toList());
            block2: for (FTDevice ftDevice : devices) {
                for (SupportedDevices xSsup : xSsupported) {
                    logger.finest(String.format("Trying %s...\n", xSsup.getDescription()));
                    if (!ftDevice.getDevDescription().equals(xSsup.getDescription())) continue;
                    this.device = ftDevice;
                    this.device.open();
                    this.hardwareSpecs = xSsup.getHardwareSpecs();
                    continue block2;
                }
            }
            if (this.device == null) {
                logger.finest("No device could be opened");
                return -1;
            }
            this.xSfw_usb_setup(2000000L, (short)2);
            this.frontbufIdx = 0;
            this.backbufIdx = 0;
            this.exSIDthreadOutput.setDaemon(true);
            this.exSIDthreadOutput.start();
            this.xSfw_usb_purge_buffers();
            this.xSoutb((byte)-3, 1);
            this.xSread(new byte[1], 1);
            return 0;
        }
        catch (FTD2XXException | InterruptedException e1) {
            e1.printStackTrace();
            return -1;
        }
    }

    @Override
    public void exSID_exit() {
        try {
            if (this.device != null) {
                this.exSID_reset((byte)0);
                this.xSoutb((byte)-3, -1);
                this.exSIDthreadOutput.join();
                this.xSfw_usb_purge_buffers();
                this.xSfw_usb_close();
                this.device = null;
            }
            this.clkdrift = 0L;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exSID_reset(byte volume) {
        try {
            this.xSoutb((byte)-1, 1);
            this.usleep(100);
            this.exSID_write((byte)24, volume, 1);
            this.clkdrift = 0L;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int exSID_clockselect(int clock) {
        try {
            if (1 != this.hardwareSpecs.getModel()) {
                return -1;
            }
            ClockSelect clk = ClockSelect.get(clock);
            switch (clk) {
                case XS_CL_PAL: {
                    this.xSoutb((byte)61, 1);
                    break;
                }
                case XS_CL_NTSC: {
                    this.xSoutb((byte)62, 1);
                    break;
                }
                case XS_CL_1MHZ: {
                    this.xSoutb((byte)63, 1);
                    break;
                }
                default: {
                    return -1;
                }
            }
            this.usleep(100);
            this.clkdrift = 0L;
            return 0;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public int exSID_audio_op(int operation) {
        try {
            if (1 != this.hardwareSpecs.getModel()) {
                return -1;
            }
            AudioOp op = AudioOp.get(operation);
            switch (op) {
                case XS_AU_6581_8580: {
                    this.xSoutb((byte)93, 0);
                    break;
                }
                case XS_AU_8580_6581: {
                    this.xSoutb((byte)94, 0);
                    break;
                }
                case XS_AU_8580_8580: {
                    this.xSoutb((byte)95, 0);
                    break;
                }
                case XS_AU_6581_6581: {
                    this.xSoutb((byte)125, 0);
                    break;
                }
                case XS_AU_MUTE: {
                    this.xSoutb((byte)126, 0);
                    break;
                }
                case XS_AU_UNMUTE: {
                    this.xSoutb((byte)127, 0);
                    break;
                }
                default: {
                    return -1;
                }
            }
            return 0;
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public void exSID_chipselect(int chip) {
        try {
            this.clkdrift -= this.hardwareSpecs.getCsioctlCycles();
            ChipSelect ch = ChipSelect.get(chip);
            switch (ch) {
                case XS_CS_CHIP0: {
                    this.xSoutb((byte)-67, 0);
                    break;
                }
                case XS_CS_CHIP1: {
                    this.xSoutb((byte)-66, 0);
                    break;
                }
                default: {
                    this.xSoutb((byte)-65, 0);
                    break;
                }
            }
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int exSID_hwmodel() {
        switch (this.hardwareSpecs.getModel()) {
            case 0: {
                return HardwareModel.XS_MD_STD.getHardwareModel();
            }
            case 1: {
                return HardwareModel.XS_MD_PLUS.getHardwareModel();
            }
        }
        return -1;
    }

    @Override
    public short exSID_hwversion() {
        try {
            this.xSoutb((byte)-2, 0);
            this.xSoutb((byte)-3, 1);
            byte[] inbuf = new byte[2];
            this.xSread(inbuf, 2);
            return (short)(inbuf[0] << 8 | inbuf[1]);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void xSdelay(long cycles) throws FTD2XXException, InterruptedException {
        while (cycles >= this.hardwareSpecs.getMindelCycles()) {
            this.xSoutb((byte)-99, 0);
            cycles -= this.hardwareSpecs.getMindelCycles();
            this.clkdrift -= this.hardwareSpecs.getMindelCycles();
        }
    }

    private void xSlongdelay(long cycles) throws FTD2XXException, InterruptedException {
        byte[] dummy = new byte[1];
        int flush = 0 == this.hardwareSpecs.getModel() ? 1 : 0;
        int multiple = (int)(cycles - this.hardwareSpecs.getLdelayOffs());
        long delta = multiple % 501;
        if ((multiple /= 501) < 0) {
            return;
        }
        while (multiple >= 255) {
            this.exSID_write((byte)-98, (byte)-1, flush);
            if (flush != 0) {
                this.xSread(dummy, 1);
            }
            multiple -= 255;
        }
        if (multiple != 0) {
            this.exSID_write((byte)-98, (byte)multiple, flush);
            if (flush != 0) {
                this.xSread(dummy, 1);
            }
        }
        this.xSdelay(delta);
    }

    @Override
    public void exSID_delay(long cycles) {
        try {
            this.clkdrift += cycles;
            if (this.clkdrift <= this.hardwareSpecs.getWriteCycles()) {
                return;
            }
            long delay = this.clkdrift - this.hardwareSpecs.getWriteCycles();
            switch (this.hardwareSpecs.getModel()) {
                default: 
            }
            this.xSdelay(delay);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void exSID_write(byte addr, byte data, int flush) throws FTD2XXException, InterruptedException {
        this.xSoutb(addr, 0);
        this.xSoutb(data, flush);
    }

    @Override
    public void exSID_clkdwrite(long cycles, byte addr, byte data) {
        try {
            this.clkdrift += cycles;
            if (this.clkdrift > this.hardwareSpecs.getWriteCycles()) {
                this.xSdelay(this.clkdrift - this.hardwareSpecs.getWriteCycles());
            }
            this.clkdrift -= this.hardwareSpecs.getWriteCycles();
            if (this.clkdrift >= 0L) {
                long adj = this.clkdrift % (this.hardwareSpecs.getMaxAdj() + 1L);
                addr = (byte)((long)addr | adj << 5);
            }
            this.exSID_write(addr, data, 0);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private byte exSID_read(byte addr, int flush) throws FTD2XXException, InterruptedException {
        byte[] data = new byte[1];
        this.xSoutb(addr, flush);
        this.xSread(data, 1);
        return data[0];
    }

    @Override
    public byte exSID_clkdread(long cycles, byte addr) {
        try {
            this.clkdrift += this.hardwareSpecs.getReadOffsetCycles();
            this.clkdrift += cycles;
            if (this.clkdrift > this.hardwareSpecs.getReadPreCycles()) {
                this.xSdelay(this.clkdrift - this.hardwareSpecs.getReadPreCycles());
            }
            this.clkdrift -= this.hardwareSpecs.getReadPreCycles();
            if (this.clkdrift >= 0L) {
                long adj = this.clkdrift % (this.hardwareSpecs.getMaxAdj() + 1L);
                addr = (byte)((long)addr | adj << 5);
            }
            this.clkdrift -= this.hardwareSpecs.getReadPostCycles();
            return this.exSID_read(addr, 1);
        }
        catch (FTD2XXException | InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private void xSfw_usb_setup(long baudrate, short latency) throws FTD2XXException, IllegalArgumentException {
        this.device.setBaudRate(baudrate);
        this.device.setDataCharacteristics(WordLength.BITS_8, StopBits.STOP_BITS_1, Parity.PARITY_NONE);
        this.device.setFlowControl(FlowControl.FLOW_NONE);
        this.device.setLatencyTimer(latency);
    }

    private void xSfw_usb_purge_buffers() throws FTD2XXException {
        this.device.purgeBuffer(true, true);
    }

    private void xSfw_usb_close() throws FTD2XXException {
        this.device.close();
    }

    private void usleep(int delayUs) {
        int delayNs = delayUs * 1000;
        long start = System.nanoTime();
        long end = 0L;
        while (start + (long)delayNs >= (end = System.nanoTime())) {
        }
    }
}

